<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateConfigShippoTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('config_shippo')) {
            Schema::create('config_shippo', function (Blueprint $table) {
                $table->integer('shop_id')->unsigned()->index();
                $table->text('merchant_key')->nullable();
                $table->boolean('sandbox')->nullable()->default(true);
                $table->timestamps();

                $table->primary('shop_id');
                $table->foreign('shop_id')->references('id')->on('shops')->onDelete('cascade');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasTable('config_shippo')) {
            Schema::dropIfExists('config_shippo');
        }
    }
}
