<?php

namespace Incevio\Package\Shippo\Database\Seeds;

use Carbon\Carbon;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use App\Models\ShippingMethod;

class ShippoSeeder extends Seeder
{
    public function run()
    {
        if (DB::table('shipping_methods')->where('code', 'shippo')->first()) {
            return;
        }

        DB::table('shipping_methods')->insert([
            'name' => 'Shippo',
            'code' => 'shippo',
            'type' => ShippingMethod::TYPE_ONLINE,
            'company_name' => 'Shippo',
            'website' => 'https://www.shippo.com/',
            'help_doc_link' => 'https://goshippo.com/products/api',
            'description' => 'The Shippo plugin simplifies your shipping process by automatically fetching shipping label prices directly from your Shippo API, saving you time and effort.',
            'admin_description' => 'Shippo simplifies the shipping process by allowing customers to choose their preferred carrier from a variety of options, ensuring a personalized and convenient shipping experience.',
            'admin_help_doc_link' => 'https://docs.shippo.com/',
            'order' => 1,
            'enabled' => true,
            'created_at' => Carbon::Now(),
            'updated_at' => Carbon::Now(),
        ]);
    }
}
