<?php

use Illuminate\Support\Facades\Route;
use Incevio\Package\Shippo\Http\Controllers\ConfigShippoController;
use Incevio\Package\Shippo\Http\Controllers\ShippoController;

// Storefront route
Route::middleware(['web', 'storefront'])->group(function () {
  Route::any('shippo/order/{order}/shippinglabels', [
    ShippoController::class,
    'getShippingLabels'
  ])->name('shippo.shipping.process');

  Route::any('shippo/carriers', [
    ShippoController::class,
    'getCarriers'
  ])->name('shippo.allcarriers');
});

// Merchant Routes
Route::middleware(['web', 'auth'])
  ->prefix('admin/setting/shippo')
  ->name('admin.setting.shippo.')
  ->group(function () {
    Route::get('activate', [
      ConfigShippoController::class,
      'activate'
    ])->name('activate');

    Route::put('update', [
      ConfigShippoController::class,
      'update'
    ])->name('update');

    Route::get('deactivate', [
      ConfigShippoController::class,
      'deactivate'
    ])->name('deactivate');
  });

Route::get('admin/shipping/shippo', [
  ConfigShippoController::class,
  'index'
])->name('admin.shipping.shippo.index')
  ->middleware(['web', 'auth']);

// Route::middleware(['web', 'auth'])
//   ->prefix('admin/shipping/shippo')
//   ->name('admin.shipping.shippo.')
//   ->group(function () {
//     Route::get('index', [
//       ConfigShippoController::class,
//       'index'
//     ])->name('index');
//   });
