<?php

namespace Incevio\Package\Shippo\Exceptions;

use Exception;

class ShippoApiException extends Exception
{
    /**
     * The Shippo API error code.
     *
     * @var int
     */
    protected $errorCode;

    /**
     * The Shippo API error message.
     *
     * @var string
     */
    protected $errorMessage;

    /**
     * Create a new ShippoApiException instance.
     *
     * @param int    $errorCode    The Shippo API http error code
     * @param string $errorMessage The Shippo API error message
     */
    public function __construct($errorCode, $errorMessage)
    {
        $this->errorCode = $errorCode;
        $this->errorMessage = $errorMessage;

        parent::__construct($errorMessage, $errorCode);
    }

    /**
     * Get the Shippo API error code.
     *
     * @return int
     */
    public function getErrorCode()
    {
        return $this->errorCode;
    }

    /**
     * Get the Shippo API error message.
     *
     * @return string
     */
    public function getErrorMessage()
    {
        return $this->errorMessage;
    }
}