<?php

namespace Incevio\Package\Shippo\Http\Controllers;

// use App\Common\Authorizable;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Controller;
use Incevio\Package\Shippo\Models\ConfigShippo;
use Illuminate\Http\Request;
use App\Models\Config;
use App\Helpers\ListHelper;
use App\Models\ShippingMethod;

class ConfigShippoController extends Controller
{
    // use Authorizable;

    private $model_name;

    public function __construct()
    {
        parent::__construct();

        $this->model_name = trans('app.model.shipping_method');
    }

    // Doc block missinng
    public function index()
    {
        $config = Config::findOrFail(Auth::user()->merchantId());
        $shipping_methods = ShippingMethod::get();
        $shipping_method_types = ListHelper::shipping_method_types();

        return view('shippo::config', compact('config', 'shipping_method_types', 'shipping_methods'));
    }

    /**
     * Activate the shippo plugin
     *
     * @return \Illuminate\Http\Response
     */
    public function activate()
    {
        if (config('app.demo') == true) {
            return view('demo_modal');
        }

        $config = ConfigShippo::firstOrCreate(['shop_id' => Auth::user()->merchantId()]);

        return view('shippo::config_modal', compact('config'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        $config = ConfigShippo::firstOrCreate(['shop_id' => Auth::user()->merchantId()]);

        ConfigShippo::where('shop_id', $config->shop_id)
            ->update([
                'merchant_key' => $request->merchant_key,
                'sandbox' => $request->sandbox
            ]);

        return back()->with('success', trans('messages.updated', ['model' => $this->model_name]));
    }

    /**
     * Deactivate the shippo plugin
     *
     * @return \Illuminate\Http\Response
     */
    public function deactivate()
    {
        $config = ConfigShippo::firstOrCreate(['shop_id' => Auth::user()->merchantId()]);

        $config->delete();

        return back()->with('success', trans('messages.updated', ['model' => $this->model_name]));
    }
}
