<?php

namespace Incevio\Package\Shippo\Http\Controllers;

use App\Models\Carrier;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Incevio\Package\Shippo\Services\ShippoShippingService;

class ShippoController extends Controller
{
    /**
     * Return a list of labels for shipping price
     * @param \Illuminate\Http\Request
     * @return mixed
     */
    public function getShippingLabels(Request $request)
    {
        return (new ShippoShippingService(Auth::user()->shop_id))->createShipment();
    }

    /**
     * A method that refreshes all the carriers registered with shippo
     * @param \Illuminate\Http\Request
     */
    public function getCarriers(Request $request)
    {
        $shipping_service = new ShippoShippingService(Auth::user()->shop_id);

        try {
            $shippo_carrier_info = $shipping_service->getAvailableCarrierDetails()->results;

            Carrier::where('shop_id', Auth::user()->shop_id)
                ->where('source', 'shippo')
                ->delete();

            foreach ($shippo_carrier_info as $shippo_info) {
                $carrier = new Carrier();
                $carrier->shop_id = Auth::user()->shop_id;
                $carrier->name = $shippo_info->carrier_name;
                $carrier->email = $shippo_info->object_owner;
                $carrier->active = true;
                $carrier->source = 'shippo';
                $carrier->save();
            }

            return redirect()->route('admin.shipping.carrier.index');
        } catch (\Exception $e) {
            Log::error('Error while calling getCarriers: ' . $e->getMessage());

            return redirect()->back()->with('error', $e->getMessage());
        }
    }
}
